#ifndef _CDISPLAY_H
#define _CDISPLAY_H

        #define Speed_mode

        #define GLCD_CTRL_PORT    PORTC    // PORT for LCD control signals
        #define GLCD_CTRL_DDR    DDRC    // DDR register of LCD_CTRL_PORT
        #define GLCD_CTRL_RS     7        // pin for LCD Register Select
        #define GLCD_CTRL_RW     6        // pin for LCD Read/Write
        #define GLCD_CTRL_E      5        // pin for LCD Enable
        #define GLCD_CTRL_CS0    4        // pin for LCD Controller 0 Chip Select
        #define GLCD_CTRL_CS1    3        // pin for LCD Controller 1 Chip Select(*)
        #define GLCD_CTRL_CS2    1        // pin for LCD Controller 2 Chip Select(*)
        #define GLCD_CTRL_CS3    1        // pin for LCD Controller 3 Chip Select(*)
        #define GLCD_CTRL_RESET  2        // pin for LCD Reset
        // (*) NOTE: additonal controller chip selects are optional and
        // will be automatically used per each step in 64 pixels of display size
        // Example: Display with 128 hozizontal pixels uses 2 controllers

        #define GLCD_DATA_PORT    PORTA    // PORT for LCD data signals
        #define GLCD_DATA_DDR    DDRA    // DDR register of LCD_DATA_PORT
        #define GLCD_DATA_PIN    PINA    // PIN register of LCD_DATA_PORT
		
		
		// LCD geometry defines (change these definitions to adapt code/settings)
		#define GLCD_XPIXELS            128        // pixel width of entire display
		#define GLCD_YPIXELS            64        // pixel height of entire display
		#define GLCD_CONTROLLER_XPIXELS    64        // pixel width of one display controller

#endif